!(function (t) {
   "use strict"; 

    t(document).ready(function(){
        t('.eel-search-open-btn').on('click', function(){
            t('.eel-search-lightbox').addClass('eel-lightbox');
            setTimeout(function() {
                t('.eel-search-lightbox .eel-search-field').focus();
            }, 1000);
        });
        t('.eel-search-close-btn, .eel-search-overlay').on('click', function(){
            t('.eel-search-lightbox').removeClass('eel-lightbox');
        });

        // service sticky class insert 
        t(document).ready(function() {
            t('body').addClass('rt_service_sticky');
        });
    });
    t(document).on("click", ".menu-cart-area", function () {
        t(".cart-icon-total-products").addClass("visible-cart"), t(".body-overlay-cart").addClass("overlayshow");
    }),
    t(document).on("click", ".body-overlay-cart", function () {
        t(this).removeClass("overlayshow"), t(".cart-icon-total-products").removeClass("visible-cart");
    }),
    t(document).on("click", ".close-cart", function () {
        t(".cart-icon-total-products").removeClass("visible-cart"), t(".body-overlay-cart").removeClass("overlayshow");
    }),
    t(document).on("click", ".translate__lang a", function (e) {
        e.preventDefault();
        var o = t(this).text();
        t(".selected__lang").text(o);
    }),
    t(document).on("click", "#langSwitcher", function () {
        t(".translate__lang").toggleClass("show");
    }),
    t(document).on("click", function (e) {
        t(e.target).closest("#langSwitcher").length || t(".translate__lang").removeClass("show");
    }),
    document.addEventListener("DOMContentLoaded", function () {
        const t = document.querySelector(".circle-text");
        if (t) {
            const e = t.querySelectorAll("span");
            let o = 0;
            const a = 360 / e.length;
            e.forEach((t, e) => {
                (t.style.transform = `rotate(${o}deg) translateX(150px)`), (o += a);
            });
        }
    }),
    window.addEventListener("load", function () {
        t(".rts-filter").imagesLoaded(function () {
            var e = t(".rts-filter").isotope({ itemSelector: ".grid-item", percentPosition: !0, masonry: { columnWidth: ".grid-item" }, animationOptions: { duration: 750, easing: "linear", queue: !1 } });
            t(".portfolio-filter button").on("click", function (o) {
                var a = t(this).attr("data-filter");
                e.isotope({ filter: a }), t(this).siblings(".active").removeClass("active"), t(this).addClass("active"), o.preventDefault();
            });
        });
    }),
    
    new WOW().init();

    t( window ).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/react-heading.default', rt_heading);
        elementorFrontend.hooks.addAction('frontend/element_ready/react-video.default', rt__popup);
        elementorFrontend.hooks.addAction('frontend/element_ready/rt-react-image.default', rt__img_scroll);
        elementorFrontend.hooks.addAction('frontend/element_ready/rt-react-image.default', rt__img_reveal);
        elementorFrontend.hooks.addAction('frontend/element_ready/rt-react-image.default', rt__img_scroll_top);
        elementorFrontend.hooks.addAction('frontend/element_ready/rt-counter.default', rt__init_counters);
        elementorFrontend.hooks.addAction('frontend/element_ready/rt-progress-bar.default', rt__progressbar);
        elementorFrontend.hooks.addAction("frontend/element_ready/rt-tab-advance.default", rt__initEeTabs);

    });

    // heading animation 
    function rt_heading () {
        if ( t('.rts-text-anime-style-1').length && window.innerWidth > 767 ) {
            let animatedTextElements = document.querySelectorAll('.rts-text-anime-style-1');
            animatedTextElements.forEach((element) => {
                //Reset if needed
                if (element.animation) {
                    element.animation.progress(1).kill();
                    element.split.revert();
                }

                element.split = new SplitText(element, {
                    type: "lines,words,chars",
                    linesClass: "split-line",
                });
                gsap.set(element, { perspective: 400 });

                gsap.set(element.split.chars, {
                    opacity: 0,
                    x: "50",
                });

                element.animation = gsap.to(element.split.chars, {
                    scrollTrigger: { trigger: element, start: "top 95%" },
                    x: "0",
                    y: "0",
                    rotateX: "0",
                    opacity: 1,
                    duration: 1,
                    ease: Back.easeOut,
                    stagger: 0.02,
                });
            });
        }
    }

    // video
    function rt__popup() {
        if ( t('.popup-videos').length ) {
            t('.popup-videos').magnificPopup({
                disableOn: 10,
                type: 'iframe',
                mainClass: 'mfp-fade',
                removalDelay: 160,
                preloader: false,
                fixedContentPos: false
            });
        }
    }

    // scroll animation
    function rt__img_scroll() {
        t( document ).ready( function () {
            if (t(".scroll-animate-img").length > 0) {
                gsap.to(".scroll-animate-img", {
                scrollTrigger: {
                    start: "top bottom",
                    end: "bottom top",
                    scrub: 1,
                },
                x: 250,
                });
            }
        });
    }

    // image reveal
    function rt__img_reveal( tscope ) {
        gsap.registerPlugin(ScrollTrigger);

        tscope.find('.rts-reveal-one').each(function () {
            const container = this;
            const image = container.querySelector('.rts-reveal-image-one');

            gsap.timeline({
                scrollTrigger: {
                    trigger: container,
                    start: "top 100%",
                    end: "top 0%",
                    toggleActions: "play none none none"
                }
            })
            .set(container, { autoAlpha: 1 })
            .from(container, { xPercent: 100, duration: 1.5, ease: "power2.out" })
            .from(image, { xPercent: -100, scale: 1.3, duration: 1.5, ease: "power2.out" }, "<");
        });
    }

    // scroll top bottom animate
    function rt__img_scroll_top(tscope) {
        gsap.registerPlugin(ScrollTrigger);

        tscope.find('.scroll-animate-vertical').each(function () {
            const growActive = this; // 'this' is already the .grow element

            const growTl = gsap.timeline({
                scrollTrigger: {
                    trigger: growActive,
                    scrub: 1,
                    start: "top 90%",
                    end: "+=1000"
                }
            });

            growTl.to(growActive, {
                duration: 1,
                y: 60,
                ease: "power1.out"
            });
        });
    }

    // Counter
    function rt__init_counters(tscope) {
        const $ = jQuery;

        // --- Odometer ---
        const $odometers = $('.odometer');
        if ($odometers.length && typeof Odometer !== "undefined") {
            const isInView = el => {
                const r = el.getBoundingClientRect();
                return r.top < window.innerHeight && r.bottom > 0;
            };

            $odometers.each(function () {
                this.odometer = new Odometer({ el: this, value: 0, format: '(,ddd)', theme: 'default' });
            });

            const triggerOdometer = () => {
                $odometers.each(function () {
                    const $el = $(this);
                    if (isInView(this) && !$el.hasClass('odometer-triggered')) {
                        $el.addClass('odometer-triggered').text($el.attr('data-count') || 0);
                    }
                });
            };

            triggerOdometer();
            $(window).on('scroll', () => requestAnimationFrame(triggerOdometer));
        }

        // --- Radial Progress ---
        const $window = $(window);
        if (tscope.find('.radial-progress').length) {
            const animateRadial = $svg => {
                const $c = $svg.find('circle.bar--animated');
                const r = $c.attr('r'), p = $svg.data('countervalue');
                const c = 2 * Math.PI * r, o = c - (p / 100) * c;
                $c.css({ 'stroke-dasharray': c, 'stroke-dashoffset': c }).animate({ 'stroke-dashoffset': o }, 2800);
            };

            const checkView = () => {
                $('.countervalue.start').each(function () {
                    const $el = $(this), top = $el.offset().top, bottom = top + $el.outerHeight();
                    const vTop = $window.scrollTop(), vBottom = vTop + $window.height();

                    if (bottom > vTop && top < vBottom) {
                        $el.removeClass('start');
                        const val = parseFloat($el.text());
                        if (!isNaN(val)) {
                            $el.prop('Counter', 0).animate({ Counter: val }, {
                                duration: 2800, easing: 'swing',
                                step: now => $el.text(Number.isInteger(val) ? Math.ceil(now) + '%' : now.toFixed(2) + '$')
                            });
                        }
                        const $svg = $el.closest('.single-progress-circle').find('.radial-progress');
                        if ($svg.length) animateRadial($svg);
                    }
                });
            };

            $window.on('scroll load', checkView);
        }
    }

    // progress bar 
    function rt__progressbar( tscope ) {
        const bars = tscope.find('.rt-progress-bar .progress-bar');
        if (!bars.length) return;
        bars.each(function() {
            const bar = t(this);
            const percent = bar.attr('aria-valuenow') || 0;

            // Reset for animation
            bar.css('width', '0%');

            const observer = new IntersectionObserver(( entries, observer ) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        bar.css('transition', 'width 1.5s ease');
                        bar.css('width', percent + '%');
                        observer.unobserve(entry.target);
                    }
                });
            }, { threshold: 0.3 });
            observer.observe(this);
        });
    }

    // tab advanced
    function rt__initEeTabs(tscope) {
        const tabsWrapper = tscope[0].querySelector(".ee-tabs-wrapper");
        if (!tabsWrapper) return;

        const tabs = tabsWrapper.querySelectorAll(".ee-tab-titles li");
        const contents = tabsWrapper.querySelectorAll(".ee-tab-content");

        function slideOut(element, duration = 100) {
            return new Promise((resolve) => {
                element.style.transition = `opacity ${duration}ms, transform ${duration}ms`;
                element.style.opacity = 0;
                element.style.transform = "translateY(20px)";
                setTimeout(() => {
                    element.style.display = "none";
                    resolve();
                }, duration);
            });
        }

        function slideIn(element, duration = 100) {
            return new Promise((resolve) => {
                element.style.display = "block";
                element.style.opacity = 0;
                element.style.transform = "translateY(20px)";
                element.style.transition = `opacity ${duration}ms, transform ${duration}ms`;
                setTimeout(() => {
                    element.style.opacity = 1;
                    element.style.transform = "translateY(0)";
                }, 10);
                setTimeout(() => {
                    resolve();
                }, duration);
            });
        }

        tabs.forEach(tab => {
            tab.addEventListener("click", async function () {
                tabs.forEach(t => t.classList.remove("active"));

                const currentContent = Array.from(contents).find(c => c.style.display !== "none");
                const targetContent = tabsWrapper.querySelector("#" + this.dataset.tab);

                if (!targetContent || currentContent === targetContent) {
                    this.classList.add("active");
                    return;
                }

                if (currentContent) {
                    await slideOut(currentContent, 100);
                }

                contents.forEach(c => c.classList.remove("active"));

                this.classList.add("active");

                await slideIn(targetContent, 100);
                targetContent.classList.add("active");
            });
        });

        // Default active
        if (tabs.length && contents.length) {
            tabs[0].classList.add("active");
            contents.forEach(c => {
                c.style.display = "none";
                c.style.opacity = 0;
                c.style.transform = "translateY(20px)";
            });
            contents[0].style.display = "block";
            contents[0].style.opacity = 1;
            contents[0].style.transform = "translateY(0)";
            contents[0].classList.add("active");
        }

         const wrapper = tscope.find(".ee-tabs-wrapper");
        if (!wrapper.length) return;
        const direction = wrapper.data("tab-direction"); 
        const settings = tscope.data("settings") || {};
        if (settings && settings.tab_layout_direction) {
            wrapper.addClass("direction-" + settings.tab_layout_direction);
        }
        const iconPosition = wrapper.data("icon-position");
        if (iconPosition) {
            wrapper.addClass("icon-position-" + iconPosition);
        }
    }

    

})(jQuery);


